# 機能設計書 100-MCP（Model Context Protocol）サーバー

## 概要

本ドキュメントは、Next.jsのMCP（Model Context Protocol）サーバー機能の設計について記述する。MCPサーバーはAIエージェント向けの標準化されたインターフェースを提供し、Next.js開発サーバーのルート情報、エラー情報、メタデータ、ログ、Server Action情報などをAIエージェントが取得できるようにする。

### 本機能の処理概要

**業務上の目的・背景**：AIコーディングエージェント（Claude、Cursor等）がNext.jsプロジェクトのコンテキストを効率的に理解し、開発者を支援するためには、プロジェクト構造、エラー状態、ルーティング情報などのリアルタイムデータへのアクセスが必要である。MCPサーバーはこれらの情報を標準化されたプロトコルで提供する。

**機能の利用シーン**：
- AIコーディングエージェントがプロジェクトのルート構造を取得する場合
- AIエージェントがブラウザのエラー状態を取得してデバッグ支援を行う場合
- AIエージェントがページメタデータ（title, description等）を取得する場合
- AIエージェントがServer Actionの情報を取得する場合
- AIエージェントが開発サーバーのログを取得する場合

**主要な処理内容**：
1. MCPサーバーのシングルトン作成・管理
2. HTTPミドルウェアによるMCPリクエストの受信・処理
3. ツール登録（get_routes, get_errors, get_page_metadata, get_logs, get_server_action_by_id, get_project_metadata）
4. HMRインフラを活用したブラウザとの双方向通信
5. テレメトリによるツール使用状況の追跡

**関連システム・外部連携**：MCP SDK（@modelcontextprotocol/sdk）、HMR WebSocket、ブラウザDevOverlay。

**権限による制御**：MCPサーバーは開発モード（`next dev`）でのみ動作する。`/_next/mcp` パス配下でリクエストを受け付ける。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | MCPサーバーはAPIインターフェースであり画面を持たない |

## 機能種別

API提供 / データ連携

## 入力仕様

### 入力パラメータ

#### MCPサーバーオプション

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| projectPath | string | Yes | プロジェクトのルートパス | 有効なパス |
| distDir | string | Yes | ビルド出力ディレクトリ | 有効なパス |
| nextConfig | NextConfigComplete | Yes | Next.js設定オブジェクト | - |
| pagesDir | string \| undefined | Yes | pagesディレクトリパス | - |
| appDir | string \| undefined | Yes | appディレクトリパス | - |
| sendHmrMessage | function | Yes | HMRメッセージ送信関数 | - |
| getActiveConnectionCount | function | Yes | アクティブ接続数取得関数 | - |
| getDevServerUrl | function | Yes | 開発サーバーURL取得関数 | - |

#### get_routesツール入力

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| routerType | string | No | フィルタするルーター種別 | 'app' \| 'pages' |

### 入力データソース

HTTPリクエスト（JSON-RPC 2.0形式）、ファイルシステム（ルート情報）、HMR WebSocket（エラー情報）。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| get_project_metadata | JSON | プロジェクトパスと開発サーバーURL |
| get_routes | JSON | App Router/Pages Routerのルート一覧 |
| get_errors | JSON | コンフィグエラー、ランタイムエラー、ビルドエラー |
| get_page_metadata | JSON | ページのメタデータ（title, description等） |
| get_logs | JSON | 開発サーバーのログ |
| get_server_action_by_id | JSON | Server Actionの詳細情報 |

### 出力先

HTTPレスポンス（JSON-RPC 2.0形式）。

## 処理フロー

### 処理シーケンス

```
1. MCPミドルウェアでリクエスト受信
   └─ /_next/mcp パスのリクエストをインターセプト
2. MCPサーバーの取得/作成
   └─ シングルトンパターンでMcpServerインスタンスを管理
3. StreamableHTTPServerTransportの作成
   └─ HTTP接続をMCPトランスポートとして使用
4. リクエストボディの解析
   └─ 1MBまでのJSON-RPCリクエストをパース
5. ツールの実行
   └─ 登録済みツールからリクエストされたツールを実行
6. レスポンスの返却
   └─ JSON-RPC形式でレスポンスを送信
```

### フローチャート

```mermaid
flowchart TD
    A[HTTPリクエスト] --> B{パスが/_next/mcp?}
    B -->|No| C[next() で次のミドルウェアへ]
    B -->|Yes| D[getOrCreateMcpServer]
    D --> E[StreamableHTTPServerTransport作成]
    E --> F[mcpServer.connect]
    F --> G[parseBody リクエスト解析]
    G --> H[transport.handleRequest]
    H --> I{ツール実行}
    I --> J[get_project_metadata]
    I --> K[get_routes]
    I --> L[get_errors]
    I --> M[get_page_metadata]
    I --> N[get_logs]
    I --> O[get_server_action_by_id]
    J --> P[JSON-RPCレスポンス]
    K --> P
    L --> P
    M --> P
    N --> P
    O --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | シングルトンパターン | MCPサーバーはプロセスごとに1インスタンスのみ作成 | 常時 |
| BR-02 | 開発モード限定 | MCPサーバーは開発モード（next dev）でのみ動作 | 常時 |
| BR-03 | ブラウザ接続必須（get_errors） | get_errorsツールはアクティブなブラウザ接続がない場合エラーを返す | get_errors実行時 |
| BR-04 | テレメトリ追跡 | 各ツール呼び出しはmcpTelemetryTrackerで使用回数を記録 | ツール実行時 |
| BR-05 | ルート種別フィルタ | get_routesはrouterTypeパラメータでApp Router/Pages Routerのフィルタが可能 | routerType指定時 |
| BR-06 | リクエストボディ制限 | リクエストボディは最大1MBまで | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -32000 | Internal server error | MCPサーバー内部エラー | JSON-RPCエラーレスポンスを返却（500） |
| - | 接続なしエラー | ブラウザセッション未接続時のget_errors | "No browser sessions connected" メッセージ |
| - | ディレクトリなしエラー | pages/appディレクトリが存在しない場合のget_routes | "No pages or app directory found" メッセージ |
| - | タイムアウト | ブラウザからのHMRレスポンスタイムアウト | DEFAULT_BROWSER_REQUEST_TIMEOUT_MS で制御 |

### リトライ仕様

ツール実行のリトライはMCPクライアント側で制御される。サーバー側でのリトライは行わない。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- MCPサーバーはシングルトンパターンにより、2回目以降のリクエストでサーバー作成のオーバーヘッドがない
- get_routesはファイルシステムスキャンを行うため、プロジェクトサイズに応じた処理時間がかかる
- get_errorsはHMRを経由したブラウザ通信を行うため、ブラウザのレスポンス時間に依存

## セキュリティ考慮事項

- MCPサーバーは開発モードでのみ動作し、本番環境には含まれない
- `/_next/mcp` パスはローカル開発環境でのみアクセス可能であることが想定される
- リクエストボディのサイズ制限（1MB）によりDoS攻撃を防止

## 備考

- MCPはAnthropicが策定したModel Context Protocolの実装
- JSON-RPC 2.0プロトコルを使用
- StreamableHTTPServerTransportにより、セッションIDなしのステートレス通信を実現
- テレメトリデータはNext.jsのテレメトリシステムに統合され、匿名の使用統計として収集される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | get-or-create-mcp-server.ts | `packages/next/src/server/mcp/get-or-create-mcp-server.ts` | McpServerOptions型（11-20行目）でMCPサーバーの設定構造を理解する |
| 1-2 | mcp-telemetry-tracker.ts | `packages/next/src/server/mcp/mcp-telemetry-tracker.ts` | McpToolUsage型（8-11行目）とMcpTelemetryTracker（13-47行目） |

**読解のコツ**: MCPはJSON-RPC 2.0ベースのプロトコル。McpServerクラスは`@modelcontextprotocol/sdk`の外部ライブラリが提供するもの。registerToolメソッドでツールを登録する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | get-mcp-middleware.ts | `packages/next/src/server/mcp/get-mcp-middleware.ts` | getMcpMiddleware関数（9-44行目）がHTTPミドルウェアとしてのエントリーポイント |

**主要処理フロー**:
1. **15-18行目**: URLパスチェック（`/_next/mcp`で始まるかどうか）
2. **19行目**: シングルトンMCPサーバーの取得/作成
3. **20-22行目**: StreamableHTTPServerTransportの作成
4. **24-29行目**: サーバー接続、ボディ解析、リクエスト処理
5. **30-41行目**: エラーハンドリング（500レスポンス）

#### Step 3: MCPサーバーの作成とツール登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | get-or-create-mcp-server.ts | `packages/next/src/server/mcp/get-or-create-mcp-server.ts` | getOrCreateMcpServer関数（24-59行目）でのサーバー作成とツール登録 |

**主要処理フロー**:
- **24-27行目**: シングルトンチェック
- **29-32行目**: McpServerインスタンス作成（名前: "Next.js MCP Server", バージョン: 0.2.0）
- **34-56行目**: 6つのツール登録（get_project_metadata, get_errors, get_page_metadata, get_logs, get_server_action_by_id, get_routes）

#### Step 4: 各ツールの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | get-project-metadata.ts | `packages/next/src/server/mcp/tools/get-project-metadata.ts` | 最もシンプルなツール。MCPツール実装のパターンを理解する |
| 4-2 | get-errors.ts | `packages/next/src/server/mcp/tools/get-errors.ts` | HMRを経由したブラウザ通信パターンを理解する |
| 4-3 | get-routes.ts | `packages/next/src/server/mcp/tools/get-routes.ts` | ファイルシステムスキャンによるルート取得を理解する |

**主要処理フロー（get-errors.ts）**:
1. **48-61行目**: アクティブ接続チェック
2. **63-68行目**: createBrowserRequestでHMRメッセージ送信
3. **72-77行目**: ブラウザからのレスポンスをルート別に集約
4. **98-101行目**: formatErrorsでエラー情報を整形

**主要処理フロー（get-routes.ts）**:
1. **91-131行目**: App Routerルートの収集（collectAppFiles + processAppRoutes）
2. **135-178行目**: Pages Routerルートの収集（collectPagesFiles + processPageRoutes）
3. **195-208行目**: ルート種別ごとのグルーピングとソート

#### Step 5: テレメトリを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | mcp-telemetry-tracker.ts | `packages/next/src/server/mcp/mcp-telemetry-tracker.ts` | テレメトリ追跡のシングルトン実装（13-84行目） |

**主要処理フロー**:
- **19-22行目**: recordToolCallでツール呼び出し回数をインクリメント
- **69-83行目**: recordMcpTelemetryでテレメトリシステムにイベント送信

### プログラム呼び出し階層図

```
getMcpMiddleware (get-mcp-middleware.ts:9)
    │
    ├─ getOrCreateMcpServer (get-or-create-mcp-server.ts:24)
    │      ├─ new McpServer (MCP SDK)
    │      ├─ registerGetProjectMetadataTool
    │      ├─ registerGetErrorsTool
    │      ├─ registerGetPageMetadataTool
    │      ├─ registerGetLogsTool
    │      ├─ registerGetActionByIdTool
    │      └─ registerGetRoutesTool
    │
    ├─ StreamableHTTPServerTransport (MCP SDK)
    │
    ├─ parseBody (api-utils/node/parse-body.ts)
    │
    └─ transport.handleRequest
           │
           ├─ get_project_metadata
           │      └─ mcpTelemetryTracker.recordToolCall
           │
           ├─ get_errors
           │      ├─ mcpTelemetryTracker.recordToolCall
           │      ├─ createBrowserRequest (HMR通信)
           │      └─ formatErrors
           │
           ├─ get_routes
           │      ├─ mcpTelemetryTracker.recordToolCall
           │      ├─ collectAppFiles + processAppRoutes
           │      └─ collectPagesFiles + processPageRoutes
           │
           └─ ... (他のツール)
```

### データフロー図

```
[入力]                            [処理]                          [出力]

AIエージェント ──────▶ HTTP POST /_next/mcp ──▶ MCPミドルウェア
(JSON-RPC 2.0)                                        │
                                                       ▼
                                              MCPサーバー (ツール実行)
                                                       │
                           ┌───────────────────────────┤
                           │                           │
                    get_routes                    get_errors
                           │                           │
              ファイルシステム ──▶ ルート一覧    HMR ──▶ ブラウザ
              スキャン                                  │
                                                 エラー状態取得
                                                       │
                                                       ▼
                                              JSON-RPCレスポンス ──▶ AIエージェント
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| get-mcp-middleware.ts | `packages/next/src/server/mcp/get-mcp-middleware.ts` | ソース | MCPミドルウェア（HTTPエントリーポイント） |
| get-or-create-mcp-server.ts | `packages/next/src/server/mcp/get-or-create-mcp-server.ts` | ソース | MCPサーバーシングルトン管理・ツール登録 |
| mcp-telemetry-tracker.ts | `packages/next/src/server/mcp/mcp-telemetry-tracker.ts` | ソース | テレメトリ追跡 |
| get-project-metadata.ts | `packages/next/src/server/mcp/tools/get-project-metadata.ts` | ソース | プロジェクトメタデータツール |
| get-errors.ts | `packages/next/src/server/mcp/tools/get-errors.ts` | ソース | エラー情報取得ツール |
| get-page-metadata.ts | `packages/next/src/server/mcp/tools/get-page-metadata.ts` | ソース | ページメタデータ取得ツール |
| get-logs.ts | `packages/next/src/server/mcp/tools/get-logs.ts` | ソース | ログ取得ツール |
| get-server-action-by-id.ts | `packages/next/src/server/mcp/tools/get-server-action-by-id.ts` | ソース | Server Action取得ツール |
| get-routes.ts | `packages/next/src/server/mcp/tools/get-routes.ts` | ソース | ルート一覧取得ツール |
| format-errors.ts | `packages/next/src/server/mcp/tools/utils/format-errors.ts` | ソース | エラーフォーマットユーティリティ |
| browser-communication.ts | `packages/next/src/server/mcp/tools/utils/browser-communication.ts` | ソース | ブラウザ通信ユーティリティ |
| next-instance-error-state.ts | `packages/next/src/server/mcp/tools/next-instance-error-state.ts` | ソース | Next.jsインスタンスエラー状態管理 |
